/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.Map;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.Nullable;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.query.visitor.NeuralSearchQueryVisitor;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;

public class NeuralQueryEnricherProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    public static final String TYPE = "neural_query_enricher";
    private final String modelId;
    private final Map<String, Object> neuralFieldDefaultIdMap;

    public String getType() {
        return TYPE;
    }

    private NeuralQueryEnricherProcessor(String tag, String description, boolean ignoreFailure, @Nullable String modelId, @Nullable Map<String, Object> neuralFieldDefaultIdMap) {
        super(tag, description, ignoreFailure);
        this.modelId = modelId;
        this.neuralFieldDefaultIdMap = neuralFieldDefaultIdMap;
    }

    public SearchRequest processRequest(SearchRequest searchRequest) {
        EventStatsManager.increment(EventStatName.NEURAL_QUERY_ENRICHER_PROCESSOR_EXECUTIONS);
        QueryBuilder queryBuilder = searchRequest.source().query();
        if (queryBuilder != null) {
            queryBuilder.visit((QueryBuilderVisitor)new NeuralSearchQueryVisitor(this.modelId, this.neuralFieldDefaultIdMap));
        }
        return searchRequest;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public Map<String, Object> getNeuralFieldDefaultIdMap() {
        return this.neuralFieldDefaultIdMap;
    }

    public static class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        private static final String DEFAULT_MODEL_ID = "default_model_id";
        private static final String NEURAL_FIELD_DEFAULT_ID = "neural_field_default_id";

        public NeuralQueryEnricherProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws IllegalArgumentException {
            String modelId = ConfigurationUtils.readOptionalStringProperty((String)NeuralQueryEnricherProcessor.TYPE, (String)tag, config, (String)DEFAULT_MODEL_ID);
            Map neuralInfoMap = ConfigurationUtils.readOptionalMap((String)NeuralQueryEnricherProcessor.TYPE, (String)tag, config, (String)NEURAL_FIELD_DEFAULT_ID);
            if (modelId == null && neuralInfoMap == null) {
                throw new IllegalArgumentException("model Id or neural info map either of them should be provided");
            }
            return new NeuralQueryEnricherProcessor(tag, description, ignoreFailure, modelId, neuralInfoMap);
        }
    }
}

