/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.event.AudioDeviceEvent;
import org.jsampler.event.AudioDeviceListener;
import org.jsampler.task.Audio;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.Parameter;

public class DefaultAudioDeviceModel
implements AudioDeviceModel {
    private AudioOutputDevice audioDevice;
    private final Vector<AudioDeviceListener> listeners = new Vector();

    public DefaultAudioDeviceModel(AudioOutputDevice audioOutputDevice) {
        if (audioOutputDevice == null) {
            throw new IllegalArgumentException("audioDevice must be non null");
        }
        this.audioDevice = audioOutputDevice;
    }

    @Override
    public void addAudioDeviceListener(AudioDeviceListener audioDeviceListener) {
        this.listeners.add(audioDeviceListener);
    }

    @Override
    public void removeAudioDeviceListener(AudioDeviceListener audioDeviceListener) {
        this.listeners.remove(audioDeviceListener);
    }

    @Override
    public int getDeviceId() {
        return this.audioDevice.getDeviceId();
    }

    @Override
    public AudioOutputDevice getDeviceInfo() {
        return this.audioDevice;
    }

    @Override
    public void setDeviceInfo(AudioOutputDevice audioOutputDevice) {
        this.audioDevice = audioOutputDevice;
        this.fireSettingsChanged();
    }

    @Override
    public void setActive(boolean bl) {
        if (bl == this.getDeviceInfo().isActive()) {
            return;
        }
        this.audioDevice.setActive(bl);
        this.fireSettingsChanged();
    }

    @Override
    public boolean isActive() {
        return this.audioDevice.isActive();
    }

    @Override
    public void setBackendActive(boolean bl) {
        CC.getTaskQueue().add(new Audio.EnableDevice(this.getDeviceId(), bl));
    }

    @Override
    public void setBackendDeviceParameter(Parameter parameter) {
        CC.getTaskQueue().add(new Audio.SetDeviceParameter(this.getDeviceId(), parameter));
    }

    @Override
    public void setBackendChannelCount(int n) {
        CC.getTaskQueue().add(new Audio.SetChannelCount(this.getDeviceId(), n));
    }

    @Override
    public void setBackendChannelParameter(int n, Parameter parameter) {
        CC.getTaskQueue().add(new Audio.SetChannelParameter(this.getDeviceId(), n, parameter));
    }

    private void fireSettingsChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultAudioDeviceModel defaultAudioDeviceModel = DefaultAudioDeviceModel.this;
                DefaultAudioDeviceModel.this.fireSettingsChanged(new AudioDeviceEvent(defaultAudioDeviceModel, defaultAudioDeviceModel));
            }
        });
    }

    private void fireSettingsChanged(AudioDeviceEvent audioDeviceEvent) {
        CC.getSamplerModel().setModified(true);
        for (AudioDeviceListener audioDeviceListener : this.listeners) {
            audioDeviceListener.settingsChanged(audioDeviceEvent);
        }
    }
}

