﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appfabric/AppFabric_EXPORTS.h>
#include <aws/appfabric/model/TaskError.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppFabric {
namespace Model {

/**
 * <p>Contains information about a user access task.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UserAccessTaskItem">AWS
 * API Reference</a></p>
 */
class UserAccessTaskItem {
 public:
  AWS_APPFABRIC_API UserAccessTaskItem() = default;
  AWS_APPFABRIC_API UserAccessTaskItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFABRIC_API UserAccessTaskItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFABRIC_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the application.</p>
   */
  inline const Aws::String& GetApp() const { return m_app; }
  inline bool AppHasBeenSet() const { return m_appHasBeenSet; }
  template <typename AppT = Aws::String>
  void SetApp(AppT&& value) {
    m_appHasBeenSet = true;
    m_app = std::forward<AppT>(value);
  }
  template <typename AppT = Aws::String>
  UserAccessTaskItem& WithApp(AppT&& value) {
    SetApp(std::forward<AppT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the application tenant.</p>
   */
  inline const Aws::String& GetTenantId() const { return m_tenantId; }
  inline bool TenantIdHasBeenSet() const { return m_tenantIdHasBeenSet; }
  template <typename TenantIdT = Aws::String>
  void SetTenantId(TenantIdT&& value) {
    m_tenantIdHasBeenSet = true;
    m_tenantId = std::forward<TenantIdT>(value);
  }
  template <typename TenantIdT = Aws::String>
  UserAccessTaskItem& WithTenantId(TenantIdT&& value) {
    SetTenantId(std::forward<TenantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID of the task.</p>
   */
  inline const Aws::String& GetTaskId() const { return m_taskId; }
  inline bool TaskIdHasBeenSet() const { return m_taskIdHasBeenSet; }
  template <typename TaskIdT = Aws::String>
  void SetTaskId(TaskIdT&& value) {
    m_taskIdHasBeenSet = true;
    m_taskId = std::forward<TaskIdT>(value);
  }
  template <typename TaskIdT = Aws::String>
  UserAccessTaskItem& WithTaskId(TaskIdT&& value) {
    SetTaskId(std::forward<TaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Error from the task, if any.</p>
   */
  inline const TaskError& GetError() const { return m_error; }
  inline bool ErrorHasBeenSet() const { return m_errorHasBeenSet; }
  template <typename ErrorT = TaskError>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = TaskError>
  UserAccessTaskItem& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_app;
  bool m_appHasBeenSet = false;

  Aws::String m_tenantId;
  bool m_tenantIdHasBeenSet = false;

  Aws::String m_taskId;
  bool m_taskIdHasBeenSet = false;

  TaskError m_error;
  bool m_errorHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppFabric
}  // namespace Aws
